<?php
namespace BooklyStaffCabinet\Frontend\Modules\StaffSchedule;

use Bookly\Backend\Components\Schedule\Component as ScheduleComponent;
use Bookly\Lib as BooklyLib;

/**
 * Class Ajax
 * @package BooklyStaffCabinet\Frontend\Modules\StaffSchedule
 */
class Ajax extends BooklyLib\Base\Ajax
{
    /** @var BooklyLib\Entities\Staff */
    protected static $staff;

    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array( '_default' => 'staff', );
    }

    public static function getSchedule()
    {
        $location_id = null;
        $schedule = new ScheduleComponent( 'start_time[{index}]', 'end_time[{index}]' );
        $ss_ids = array();
        foreach ( self::$staff->getScheduleItems( $location_id ) as $item ) {
            $id = $item->getId();
            $schedule->addHours( $id, $item->getDayIndex(), $item->getStartTime(), $item->getEndTime() );
            $ss_ids[ $id ] = $item->getDayIndex();
        }

        foreach (
            BooklyLib\Entities\ScheduleItemBreak::query()
                ->whereIn( 'staff_schedule_item_id', array_keys( $ss_ids) )
                ->sortBy( 'start_time, end_time' )
                ->fetchArray() as $break
        ) {
            $schedule->addBreak( $break['staff_schedule_item_id'], $break['id'], $break['start_time'], $break['end_time'] );
        }
        $staff_id = self::$staff->getId();
        $html = self::renderTemplate( 'schedule', compact( 'schedule', 'staff_id', 'location_id', 'ss_ids' ), false );

        wp_send_json_success( compact( 'html' ) );
    }

    /**
     * @inheritDoc
     */
    protected static function hasAccess( $action )
    {
        if ( parent::hasAccess( $action ) ) {
            self::$staff = BooklyLib\Entities\Staff::query()->where( 'wp_user_id', get_current_user_id() )->findOne();

            return self::$staff->isLoaded();
        }

        return false;
    }
}