<?php
namespace BooklyStaffCabinet\Frontend\Modules\StaffServices;

use BooklyStaffCabinet\Lib;
use Bookly\Lib as BooklyLib;
use Bookly\Backend\Components\Dialogs\Staff\Edit\Forms;

/**
 * Class Ajax
 * @package BooklyStaffCabinet\Frontend\Modules\StaffServices
 */
class Ajax extends BooklyLib\Base\Ajax
{
    /** @var BooklyLib\Entities\Staff */
    protected static $staff;

    /**
     * @inheritDoc
     */
    protected static function permissions()
    {
        return array( '_default' => 'staff', );
    }

    public static function getServices()
    {
        $staff_id   = self::$staff->getId();
        $attributes = array();
        foreach ( (array) self::parameter( 'attributes' ) as $key => $value ) {
            $attributes[ $key ] = array_fill_keys( explode( ',', $value ), true );
        }
        $form = new Forms\StaffServices();
        $form->load( $staff_id );

        $html = self::renderTemplate( 'services', compact( 'staff_id', 'form', 'attributes' ), false );
        wp_send_json_success( compact( 'html' ) );
    }


    /**
     * @inheritDoc
     */
    protected static function hasAccess( $action )
    {
        if ( parent::hasAccess( $action ) ) {
            self::$staff = BooklyLib\Entities\Staff::query()->where( 'wp_user_id', get_current_user_id() )->findOne();

            return self::$staff->isLoaded();
        }

        return false;
    }
}