<?php
/**
 * Simple_Job_Board_Captcha_Public Class
 *
 * * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 * 
 * @link       http://presstigers.com/
 * @since      1.0.0
 *
 * @package    Simple_Job_Board_Captcha
 * @subpackage Simple_Job_Board_Captcha/public
 * @author     PressTigers <support@presstigers.com>
 */
class Simple_Job_Board_Captcha_Public {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of the plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version) {

        $this->plugin_name = $plugin_name;
        $this->version = $version;

        /**
         * The class responsible for Ajax Call on Job Submission in the front end area.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-simple-job-board-captcha-ajax.php';

        // Action -> Add CAPTCHA to Job Application
        add_action('sjb_job_application_form_fields_end', array($this, 'display_recaptcha'), 9999);
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_styles() {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Simple_Job_Board_Captcha_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Simple_Job_Board_Captcha_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/simple-job-board-captcha-public.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts() {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Simple_Job_Board_Captcha_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Simple_Job_Board_Captcha_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/simple-job-board-captcha-public.js', array('jquery'), $this->version, TRUE);
        
        // Retrive reCAPTCHA settings
        if( get_option('job_board_recaptcha') ) {
            $recaptcha = get_option('job_board_recaptcha');
        } else {
            $recaptcha['language'] = 'en';
        }
        
        wp_register_script('job-application-recaptcha', 'https://www.google.com/recaptcha/api.js?hl=' . trim($recaptcha['language']) . '>', array('jquery'), NULL, TRUE);
    }

    /**
     * Add reCAPTCHA to job application.
     * 
     * @since   2.3.2
     */
    public function display_recaptcha() {

        // reCAPTCHA Script
        wp_enqueue_script('job-application-recaptcha');        
        $recaptcha = get_option('job_board_recaptcha');
        
        if ( !empty($recaptcha['site_key'] ) ) {
            ?>

            <!-- reCAPTCHA Section --> 
            <div class="form-group">
                <div class="g-recaptcha" data-sitekey="<?php echo htmlentities(trim($recaptcha['site_key'])); ?>"></div>
            </div>
            <?php
        }
    }

}