<?php if (!defined('ABSPATH')) { exit; } // Exit if accessed directly
/**
 * SJB_Job_Expirator_Meta_box Class
 * 
 * @link        https://wordpress.org/plugins/simple-job-board
 * @since       2.4.3
 * 
 * @package     Simple_Job_Board_Bee_Recruitment
 * @subpackage  Simple_Job_Board_Bee_Recruitment/admin
 * @author      PressTigers <support@presstigers.com>
 */
if (!class_exists('SJB_Job_Expirator_Meta_box')) {

    class SJB_Job_Expirator_Meta_box {

        /**
         * Initialize the class and set its properties.
         *
         * @since   2.4.3
         */
        public function __construct() {

            // Action -> Post Type -> Jobpost -> Add Meta Boxes. 
            add_action('add_meta_boxes', array($this, 'add_meta_box'));

            // Action -> Post Type -> Jobpost -> Save "Job Expirator" Meta Box.
            add_action( 'sjb_save_jobpost_meta', array($this, 'sjb_save_jobpost_meta'), 999 );

            // Filter -> Filter Unpublished Jobs
            add_filter('views_edit-jobpost', array($this, 'views_filter_for_own_posts'));
        }

        /**
         * Add jobpost meta box.
         *
         * @since   2.4.3
         */
        public function add_meta_box() {
            add_meta_box('job-expirator_options', __('Job Expirator', 'simple-job-board-bee-recruitment'), array($this, 'sjb_meta_box_output'), 'jobpost', 'side', 'high');
        }

        /**
         * Add Meta box for "Job Expirator"
         * 
         * @since   2.4.3
         */
        public function sjb_meta_box_output() {
            global $post;

            // Retrieve job expiry date
            $expiry_date = get_post_meta($post->ID, 'sjb_job_expirator', TRUE);
            $expiry_flag = get_post_meta($post->ID, 'sjb_job_expiry_flag', TRUE);
            $expiry_flag = !empty($expiry_flag) ? $expiry_flag : '';

            // Get job published date
            $publish_date = get_the_date();
            $date = strtotime($publish_date);

            // Add 30 Days after the published date
            $date = strtotime("+30 day", $date);

            // Set expiry date
            $expiry_date = !empty($expiry_date) ? date('Y-m-d', $expiry_date) : date('Y-m-d', $date);
            ?>

            <!-- Job Expiry Start Date & Time -->
            <ul class="form-elements">

                <!-- Enable Job Expirator -->
                <li class="field-label full-width">
                    <input type="checkbox" name="job_expiry[disable]"<?php echo esc_attr($expiry_flag); ?>>
                    <label><?php esc_html_e("Enable Job Expirator", 'simple-job-board-bee-recruitment'); ?></label>
                </li>

                <!-- Job Expiry Date -->
                <li class="field-label">
                    <label><?php esc_html_e('Job Expiry Date:', 'simple-job-board-bee-recruitment'); ?></label>
                </li>
                <li class="element-field">
                    <div class="input-sec">
                        <input type="text" class="sjb-date-picker" name="job_expiry[start_date]" value="<?php echo esc_attr($expiry_date); ?>">
                    </div>
                </li>
            </ul>

            <?php
        }

        /**
         * Save "Job Expirator" Meta Box
         * 
         * @since   2.4.3
         * 
         * @param   int     $post_id    Post id
         * @return  void
         */
        public function sjb_save_jobpost_meta($post_id) {

            // Checkbox for job expiry date
            $flag = (!empty($_POST['job_expiry']['disable'])) ? "checked" : "";

            // Update flag            
            update_post_meta($post_id, 'sjb_job_expiry_flag', sanitize_text_field($flag));

            // Save job expiray date
            update_post_meta($post_id, 'sjb_job_expirator', strtotime(sanitize_text_field($_POST['job_expiry']['start_date'])));
        }
        
        /**
         * Filter Unpublished Jobs
         * 
         * @param   array   $views  Get Post Statues
         * @return  array   $views  Get Post Statues
         */
        public function views_filter_for_own_posts( $views ) {
            
            // Custom Post Type
            $post_type = get_query_var('post_type');
            $author = get_current_user_id();

            $new_views = array(
                'all' => __('All', 'simple-job-board-bee-recruitment'),
                'mine' => __('Mine', 'simple-job-board-bee-recruitment'),
            );
            
            if( 'jobpost' == $post_type) {
                foreach ( $new_views as $view => $name ) {

                    $query = array(
                        'post_type' => $post_type,
                    );

                    if ( $view == 'all' ) {
                        $query['all_posts'] = 1;
                        $class = ( get_query_var('all_posts') == 1 || get_query_var('post_status') == '' ) ? ' class="current"' : '';
                        $url_query_var = 'all_posts=1';
                    } elseif ( $view == 'mine' ) {
                        $query['author'] = $author;
                        $class = ( get_query_var('author') != '' ) ? ' class="current"' : '';
                        $url_query_var = 'author=' . $author;
                    }

                    // Job Query
                    $result = new WP_Query($query);

                    // Display Count
                    if ($result->found_posts > 0) {

                        $views[$view] = sprintf(
                            '<a href="%s"' . $class . '>' . __($name) . ' <span class="count">(%d)</span></a>', admin_url('edit.php?' . $url_query_var . '&post_type=' . $post_type), $result->found_posts
                        );
                    } else {

                        unset($views[$view]);
                    }
                }
            }
            return $views;
        }

    }

}
new SJB_Job_Expirator_Meta_box();