<?php
global $current_user, $wpdb, $wp_query;
$wpttarUserRole = $this->WPTTARGetCurrentUserCall();
$WpttarUsers = get_users();
$wpttarGetPagePermissions = $this->WPTTARGetPagePermissions();
$wpttarTeamMemberInfo = $this->WPTTARGetSettings('wpttarTeamMemberInfo');
?>
<!-- BEGIN PAGE HEADER-->
<!-- END PAGE HEADER-->
<div class="preloader">  <span class="preloader-custom-gif"></span></div>
<input type="hidden" id="current-role-member" value="<?php echo esc_attr($wpttarUserRole); ?>">
<div style="padding-left: 0px; padding-right:20px; padding-top:0px;" class="col-md-12">
    <h3 class="page-title"><?php _e('Team Members', 'wpttar'); ?></h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
             <li><a href="?page=wpttar-projects"><i class="fa fa-home"></i><?php _e('Home', 'wpttar'); ?><i class="fa fa-angle-right"></i></a></li>
            <li><?php _e('Team Members', 'wpttar'); ?></li>        
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="portlet box blue calendar">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-list"></i>
                        <?php _e('List of Team Members', 'wpttar'); ?>
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                        <thead>
                            <tr>
                                <th><?php _e('S.No', 'wpttar'); ?></th>
                                <th><?php _e('Name', 'wpttar'); ?></th>
                                <th><?php _e('Currently Working', 'wpttar'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 1;
                            foreach ($WpttarUsers as $key => $userdata) {
                                 if(isset($userdata->roles) && !empty($userdata->roles)){
                                $wpttarUserRole = implode(',', $userdata->roles);
                                 if((isset($wpttarUserRole) && !empty($wpttarUserRole)) && (isset($wpttarTeamMemberInfo) && !empty($wpttarTeamMemberInfo))){
                                if(in_array($wpttarUserRole, $wpttarTeamMemberInfo)){
                                $projectDay = '';
                                $wpttarProjects ='';
                                $userdataOfId = esc_sql($userdata->data->ID);
                                $wpttarProjectDetails = $this->WPTTARGetResultsByOrderByFieldName($this->WpttarProjectsLogTable,'developerID',$userdataOfId,'updateDate','DESC','getRow');
                                if(isset($wpttarProjectDetails->projectID) && $wpttarProjectDetails->projectID !=''){ 
                                $wpttarProjectHours = $this->WPTTARGetResultsByMultipleFields($this->WpttarProjectsLogTable,'projectID','developerID',$wpttarProjectDetails->projectID,$userdataOfId,'getResults'); 
                                $getTotalDays = $this->WPTTARGetProjectTime($wpttarProjectHours, 'totalDays');
                                $projectDays = ($getTotalDays/24);  
                                   $projectDay =  floor($projectDays); 
                                if($projectDay >0){
                                     $projectDay = $projectDay.' Days';
                                }else{
                                    $projectDay = '';
                                }
                                $wpttarProjectResults = $this->WPTTARGetTableDataByID($wpttarProjectDetails->projectID, $this->WpttarProjectsTable, 'id');    
                                $wpttarProjects =  $wpttarProjectResults->projectName; 
                                }
                                if (in_array('manage_options_projects', $wpttarGetPagePermissions)) {
                                $user_info = get_userdata($userdata->data->ID);
                                $WpttarEmployeeFirstName = $user_info->user_nicename;
                                $WpttarEmployeeLastName = '';
                                }else{
                                  $WpttarEmployeeFirstName = get_user_meta($userdata->data->ID, 'first_name', true);
                                $WpttarEmployeeLastName = get_user_meta($userdata->data->ID, 'last_name', true);   
                                }
                                ?>
                                <tr id="row">
                                    <td><?php echo esc_html($i); ?></td>
                                    <td class="text-center"><a href="?page=wpttar-developer-projects-details&developerID=<?php echo $userdataOfId; ?>"><?php
                                            if (isset($WpttarEmployeeFirstName)): echo esc_html($WpttarEmployeeFirstName . ' ');
                                            endif;
                                            ?><?php
                                            if (isset($WpttarEmployeeLastName)): echo esc_html($WpttarEmployeeLastName);
                                            endif;
                                            ?></a></td>
                                    <td><?php
                                        if (isset($wpttarProjects)) : echo esc_html($wpttarProjects);
                                        endif;
                                        ?></td>

                                </tr>  
                                <?php
                                $i++;
                            } } } }
                            ?>
                        </tbody>
                    </table>                   
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END PAGE CONTENT-->
<div class="user-timer-load-in-div"></div>
