    <?php
global $current_user, $wpdb, $wp_query;
$wpttarUserRole = $this->WPTTARGetCurrentUserCall();
  wp_enqueue_style('wpttar-jquery.simple-dtpicker-css');
 $wpttarGetPagePermissions = $this->WPTTARGetPagePermissions();
 $wpttarTimeZoneSettings = $this->WPTTARGetSettings('wpttarTimeZoneSettingsInfo');
        if (isset($wpttarTimeZoneSettings['wpttar-time-zone']) && $wpttarTimeZoneSettings['wpttar-time-zone'] != '') {
            date_default_timezone_set($wpttarTimeZoneSettings['wpttar-time-zone']);
        }
?>
<!-- BEGIN PAGE HEADER-->
<!-- END PAGE HEADER-->

<div class="preloader">  <span class="preloader-custom-gif"></span></div>
<input type="hidden" id="current-role-member" value="<?php echo esc_attr($wpttarUserRole); ?>">
<div style="padding-left: 0px; padding-right:20px; padding-top:0px;" class="col-md-12">
    <h3 class="page-title"><?php _e('Log Request', 'wpttar'); ?></h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li><a href="?page=wpttar-projects"><i class="fa fa-home"></i><?php _e('Home', 'wpttar'); ?><i class="fa fa-angle-right"></i></a></li>
            <li><?php _e('Log Request', 'wpttar'); ?></li>        
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            
            <a class="btn green" href="#addlogs" data-toggle="modal"><i class="fa fa-plus"></i><?php _e('Add Log', 'wpttar'); ?></a>
            <div class="portlet box blue calendar">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-list"></i>
                           <?php _e('Log Request List', 'wpttar'); ?>
                    </div>
                    
                </div>
                <div class="portlet-body">
                    <?php if (in_array('manage_options_projects', $wpttarGetPagePermissions)) { ?>
                    <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                        <thead>
                            <tr> 
                                <th><?php _e('Name', 'wpttar'); ?></th> 
                                <th class="text-center"><?php _e('Project Name', 'wpttar'); ?></th>
                                <th><?php _e('Start Time', 'wpttar'); ?></th>
                                <th><?php _e('End Time', 'wpttar'); ?></th>
                                <th><?php _e('Comments', 'wpttar'); ?></th>
                                <th><?php _e('Total Time', 'wpttar'); ?></th>
                                <th><?php _e('Status', 'wpttar'); ?></th>
                              
                                <th><?php _e('Date', 'wpttar'); ?></th>
                                 <?php if (isset($wpttarUserRole) && in_array('administrator', $current_user->roles)) { ?>
                                <th><?php _e('Action', 'wpttar'); ?></th>
                                 <?php } ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 1;
                           
                                 $wpttarProjectResults = $this->WPTTARGetResultsByID('pending', $this->WpttarCustomProjectLogTable,'wpttarStatus');
                               foreach ($wpttarProjectResults as $key => $wpttarProjectResult) {
                               $wpttarProjectEndDate = $this->WPTTARGetTableDataByID($wpttarProjectResult->projectID, $this->WpttarProjectsTable, 'id');
                               $getTotalHour = $this->WPTTARBetweenTime($wpttarProjectResult->startTime, $wpttarProjectResult->endTime);
                               if (in_array('manage_options_projects', $wpttarGetPagePermissions)) {
                                         $WpttarEmployeeFirstName = get_user_meta($wpttarProjectResult->wpttarUserID, 'nickname', true);
                                         $WpttarEmployeeLastName = '';   
                                        }else{
                                        $WpttarEmployeeFirstName = get_user_meta($wpttarProjectResult->wpttarUserID, 'first_name', true);
                                        $WpttarEmployeeLastName = get_user_meta($wpttarProjectResult->wpttarUserID, 'last_name', true);
                                        } 
                               ?>
                            <tr> <td style="width: 13%;"><?php
                                           if (isset($WpttarEmployeeFirstName)): echo esc_html($WpttarEmployeeFirstName . ' ');
                                                    endif;
                                                    ?><?php
                                                    if (isset($WpttarEmployeeLastName)): echo esc_html($WpttarEmployeeLastName);
                                                    endif;
                                            ?></td>
                                
                                    <td class="text-center"><?php
                                            if (isset($wpttarProjectEndDate->projectName)) : echo esc_html($wpttarProjectEndDate->projectName);
                                            endif;
                                            ?></td>
                                    
                                     <td style="width: 16%;"><?php
                                           if (isset($wpttarProjectResult->startTime)) : echo esc_html(date('d-m-Y H:i:s',  strtotime($wpttarProjectResult->startTime)));
                                        endif;
                                            ?></td>
                                      <td style="width: 16%;"><?php
                                           if (isset($wpttarProjectResult->endTime)) : echo esc_html(date('d-m-Y H:i:s',  strtotime($wpttarProjectResult->endTime)));
                                        endif;
                                            ?></td>
                                      
                                       <td style="width: 16%;"><?php
                                            if (isset($wpttarProjectResult->projectComment)) : echo esc_html($wpttarProjectResult->projectComment);
                                            endif;
                                            ?></td>
                                    <td style="width: 9%;"><?php
                                        if (isset($getTotalHour)) : echo esc_html($getTotalHour);
                                        endif;
                                        ?></td>
                                    

                                    <td style="width: 7%;">
                                        <?php if (isset($wpttarProjectResult->wpttarStatus) && $wpttarProjectResult->wpttarStatus == 'pending') { ?>
                                            <span class="label label-sm label-warning"><?php _e('Pending', 'wpttar'); ?></span>
                                        <?php } else if (isset($wpttarProjectResult->wpttarStatus) && $wpttarProjectResult->wpttarStatus == 'approved') { ?>
                                            <span class="label label-sm label-success"><?php _e('Approved', 'wpttar'); ?></span>
                                        <?php } else if (isset($wpttarProjectResult->wpttarStatus) && $wpttarProjectResult->wpttarStatus == 'rejected') { ?> 
                                            <span class="label label-sm label-danger"><?php _e('Rejected', 'wpttar'); ?></span>
                                        <?php } ?>
                                    </td>
                                    <td style="width: 7%;">
                                        <?php
                                        if (isset($wpttarProjectResult->wpttarDate)) : echo esc_html(date('d-m-Y',  strtotime($wpttarProjectResult->wpttarDate)));
                                        endif;
                                        ?>
                                    </td>
                                   <?php if (isset($wpttarUserRole) && in_array('administrator', $current_user->roles)) { ?>
                                    <td style="width: 7%;">
                                         <a class="blue color" href="#edit-change-status" data-toggle="modal" onclick="wpttarEditChangeLogStatus('<?php echo esc_js($wpttarProjectResult->id); ?>','<?php echo esc_js($wpttarProjectResult->startTime); ?>',
                                                    '<?php echo esc_js($wpttarProjectResult->endTime); ?>','<?php echo esc_js($wpttarProjectResult->projectID); ?>','<?php echo esc_js($wpttarProjectResult->projectComment); ?>','<?php echo esc_js($wpttarProjectResult->wpttarUserID); ?>');" >
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        
                                    </td>
                                   <?php } ?>       
                                </tr>
                                <?php
                                $i++;
                            } ?>
                                
                              </tbody>
                              </table>         
                                
                           <?php }
                            else{ ?>
                                 <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                        <thead>
                            <tr> 
                                 
                                <th class="text-center"><?php _e('Project Name', 'wpttar'); ?></th>
                                <th><?php _e('Start Time', 'wpttar'); ?></th>
                                <th><?php _e('End Time', 'wpttar'); ?></th>
                                <th><?php _e('Comments', 'wpttar'); ?></th>
                                <th><?php _e('Total Time', 'wpttar'); ?></th>
                                <th><?php _e('Status', 'wpttar'); ?></th>
                                <th><?php _e('Date', 'wpttar'); ?></th> 
                                <th><?php _e('Action', 'wpttar'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                               <?php 
                                $i = 1;
                               $wpttarProjectResults = $this->WPTTARGetResultsByID($current_user->ID, $this->WpttarCustomProjectLogTable, 'wpttarUserID');
                            foreach ($wpttarProjectResults as $key => $wpttarProjectResult) {
                               $wpttarProjectEndDate = $this->WPTTARGetTableDataByID($wpttarProjectResult->projectID, $this->WpttarProjectsTable, 'id');
                               $getTotalHour = $this->WPTTARBetweenTime($wpttarProjectResult->startTime, $wpttarProjectResult->endTime);
                                ?>
                            <tr id="dataRow-<?php if (isset($wpttarProjectResult->id)) : echo esc_attr($wpttarProjectResult->id);
                                        endif; ?>">
                                    <td  class="text-center"><?php
                                            if (isset($wpttarProjectEndDate->projectName)) : echo esc_html($wpttarProjectEndDate->projectName);
                                            endif;
                                            ?></td>
                                    
                                     <td style="width: 16%;"><?php
                                           if (isset($wpttarProjectResult->startTime)) : echo esc_html(date('d-m-Y H:i:s',  strtotime($wpttarProjectResult->startTime)));
                                        endif;
                                            ?></td>
                                      <td style="width: 16%;"><?php
                                           if (isset($wpttarProjectResult->endTime)) : echo esc_html(date('d-m-Y H:i:s',  strtotime($wpttarProjectResult->endTime)));
                                        endif;
                                            ?></td>
                                    <td style="width: 16%;"><?php
                                            if (isset($wpttarProjectResult->projectComment)) : echo esc_html($wpttarProjectResult->projectComment);
                                            endif;
                                            ?></td>
                                    <td style="width: 9%;"><?php
                                        if (isset($getTotalHour)) : echo esc_html($getTotalHour);
                                        endif;
                                        ?></td>
                                    

                                    <td style="width: 7%;">
                                        <?php if (isset($wpttarProjectResult->wpttarStatus) && $wpttarProjectResult->wpttarStatus == 'pending') { ?>
                                            <span class="label label-sm label-warning"><?php _e('Pending', 'wpttar'); ?></span>
                                        <?php } else if (isset($wpttarProjectResult->wpttarStatus) && $wpttarProjectResult->wpttarStatus == 'approved') { ?>
                                            <span class="label label-sm label-success"><?php _e('Approved', 'wpttar'); ?></span>
                                        <?php } else if (isset($wpttarProjectResult->wpttarStatus) && $wpttarProjectResult->wpttarStatus == 'rejected') { ?> 
                                            <span class="label label-sm label-danger"><?php _e('Rejected', 'wpttar'); ?></span>
                                        <?php } ?>
                                    </td>
                                    <td style="width: 10%;">
                                        <?php
                                        if (isset($wpttarProjectResult->wpttarDate)) : echo esc_html(date('d-m-Y',  strtotime($wpttarProjectResult->wpttarDate)));
                                        endif;
                                        ?>
                                    </td>
                                    <td style="width: 7%;">
                                        <?php if (isset($wpttarProjectResult->wpttarStatus) && $wpttarProjectResult->wpttarStatus == 'pending') { ?>
                                        
                                        <a class="blue color" href="#editLogs" data-toggle="modal" onclick="wpttarEditLogs('<?php echo esc_js($wpttarProjectResult->id); ?>','<?php echo esc_js($wpttarProjectResult->startTime); ?>',
                                                    '<?php echo esc_js($wpttarProjectResult->endTime); ?>','<?php echo esc_js($wpttarProjectResult->projectID); ?>','<?php echo esc_js($wpttarProjectResult->projectComment); ?>');" >
                                            <i class="fa fa-edit"></i>
                                            
                                        </a>
                                       <a class="red color" onclick="wpttarDeleteLogRequest('<?php echo esc_js($wpttarProjectResult->id); ?>');" >
                                            <i class="fa fa-trash"></i>
                                            
                                        </a>
                                <?php } ?>
                                    </td>
                                </tr>
                                <?php
                                $i++;
                            } 
                            }
                            ?>
                        </tbody>
                    </table>                   
                </div>
            </div>
        </div>
    </div>
</div>

<div id="addlogs" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-close"></i></button>
                <h4 class="modal-title"><strong><?php _e('Add Logs', 'wpttar'); ?></strong></h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-success display-hide" id="addlogs_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="alert alert-danger display-hide" id="addlogs_error">
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="portlet-body form">
                    <!-- BEGIN FORM-->
                    <form action="#" method="post" class="form-horizontal" id="addlog-form">
                         <input type="hidden"  name="wpttar-role" value="<?php echo $wpttarUserRole; ?>"/>
                        <div class="form-body">
                              <div class="form-group">
                                 <div class="col-md-10">
                                     <select class="form-control"  name="project-id" required>
                <option  value=""><?php _e('Select project', 'wpttar') ?></option>
                <?php
                $wpttarMembersResults = $this->WPTTARGetResultsByID($current_user->ID, $this->WpttarTeamsTable, 'teamMember');
                if (!empty($wpttarMembersResults)) {
                    foreach ($wpttarMembersResults as $wpttarMembersResult) {
                        $wpttarProjectResults = $this->WPTTARGetTableDataByID($wpttarMembersResult->projectID, $this->WpttarProjectsTable, 'id');
                        if ($wpttarProjectResults->projectStatus != 'Close') {
                            ?>
                            <option  value="<?php
                            if (isset($wpttarProjectResults->id)) : echo esc_attr($wpttarProjectResults->id);
                            endif;
                            ?>">
                                         <?php
                                         if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                         endif;
                                         ?></option>
                            <?php
                        }
                    }
                }
                ?>
                              </select></div></div>
                            <div class="form-group">
                                 <div class="col-md-5">
                                    <input class="form-control form-control-inline input-medium timepickers" name="start-time" placeholder="<?php _e('Project Date', 'wpttar'); ?>" type="text"/>
                                     <input class="form-control" type="hidden"  name="wpttar-action" value="add-log"/>
                                    <input class="form-control" type="hidden" name="developer-id" value="<?php echo esc_attr($current_user->ID); ?>"/>
                                </div>
                                <div class="col-md-5">
                                    <input class="form-control form-control-inline input-medium timepickers" name="end-time" placeholder="<?php _e('Project Date', 'wpttar'); ?>" type="text"/>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <div class="col-md-10">
                                    <textarea class="form-control form-control-inline" placeholder="<?php _e('Enter your comment', 'wpttar'); ?>" id="projectcomment" name="projectcomment"></textarea>
                                </div>
                            </div>
                           
                        </div>
                        <div class="modal-footer">
                            <button type="submit"  class=" btn blue"> <i class="fa fa-plus"></i><?php _e('Add', 'wpttar'); ?></button>
                            <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default wpttar-addlog"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
                        </div>
                    </form>
                    <!-- END FORM-->
                </div>
            </div>
        </div></div></div>
<!-- END PAGE CONTENT-->

<div id="editLogs" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-close"></i></button>
                <h4 class="modal-title"><strong><?php _e('Edit Logs', 'wpttar'); ?></strong></h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-success display-hide" id="editlogs_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="alert alert-danger display-hide" id="editlogs_error">
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="portlet-body form">
                    <!-- BEGIN FORM-->
                    <form action="#" method="post" class="form-horizontal" id="editlog-form">
                        <input type="hidden"  name="wpttar-action" value="edit-log"/>
                        <div class="form-body">
                            
                               <div class="form-group">
                                 <div class="col-md-10">
                                     <select class="form-control"  name="project-id" id="get-project-id" required>
                <option  value=""><?php _e('Select project', 'wpttar') ?></option>
                <?php
                $wpttarMembersResults = $this->WPTTARGetResultsByID($current_user->ID, $this->WpttarTeamsTable, 'teamMember');
                if (!empty($wpttarMembersResults)) {
                    foreach ($wpttarMembersResults as $wpttarMembersResult) {
                        $wpttarProjectResults = $this->WPTTARGetTableDataByID($wpttarMembersResult->projectID, $this->WpttarProjectsTable, 'id');
                        if ($wpttarProjectResults->projectStatus != 'Close') {
                            ?>
                            <option  value="<?php
                            if (isset($wpttarProjectResults->id)) : echo esc_attr($wpttarProjectResults->id);
                            endif;
                            ?>">
                                         <?php
                                         if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                         endif;
                                         ?></option>
                            <?php
                        }
                    }
                }
                ?>
                              </select></div></div>
                            <div class="form-group">
                                 <div class="col-md-5">
                                    <input class="form-control form-control-inline input-medium timepickers" name="start-time" placeholder="<?php _e('Project Date', 'wpttar'); ?>" id="get-start-date" type="text"/>
                                    
                                    <input class="form-control" type="hidden" name="developer-id" value="<?php echo esc_attr($current_user->ID); ?>"/>
                                    <input class="form-control" type="hidden" id="log-id" name="log-id"/>
                                  
                                </div>
                                <div class="col-md-5">
                                    <input class="form-control form-control-inline input-medium timepickers" name="end-time" placeholder="<?php _e('Project Date', 'wpttar'); ?>" id="get-end-date" type="text"/>
                                </div>
                            </div>
                            
                            
                            <div class="form-group">
                                <div class="col-md-10">
                                    <textarea class="form-control form-control-inline" placeholder="<?php _e('Enter your comment', 'wpttar'); ?>" id="get-projectcomment" name="projectcomment"></textarea>
                                </div>
                            </div>
                           
                        </div>
                        <div class="modal-footer">
                            <button type="submit"  class=" btn blue"> <i class="fa fa-plus"></i><?php _e('Edit', 'wpttar'); ?></button>
                            <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default wpttar-addlog"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
                        </div>
                    </form>
                    <!-- END FORM-->
                </div>
            </div>
        </div></div></div>

<div id="edit-change-status" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-close"></i></button>
                <h4 class="modal-title"><strong><?php _e('Edit Logs', 'wpttar'); ?></strong></h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-success display-hide" id="editchangelogs_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="alert alert-danger display-hide" id="editchangelogs_error">
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="portlet-body form">
                    <!-- BEGIN FORM-->
                    <form action="#" method="post" class="form-horizontal" id="edit-change-status-form">
                        <input type="hidden"  name="wpttar-action" value="edit-change-status"/>
                        <div class="form-body">
                               
                                 
                                    <input name="start-time" class="change-get-start-date" type="hidden"/>
                                    <input class="form-control" type="hidden" name="developer-id" id="change-developer-id" value=""/>
                                    <input class="form-control" type="hidden" id="change-log-id" name="log-id"/>
                                    <input class="form-control" type="hidden" name="project-id" id="change-get-project-id"/>
                                    <input name="end-time" class="change-get-end-date" type="hidden"/>
                                   
                               
                            <div class="form-group">
                                 <div class="col-md-10">
                                     <select class="form-control"  name="wpttar-status" id="wpttar-status" required>
                                    <option  value="approved"><?php _e('Approved', 'wpttar') ?></option>
                                    <option  value="rejected"><?php _e('Rejected', 'wpttar') ?></option>
                
                              </select></div></div>
                            
                            
                            <div class="form-group">
                                <div class="col-md-10">
                                    <textarea class="form-control form-control-inline" placeholder="<?php _e('Enter your comment', 'wpttar'); ?>" id="change-get-projectcomment" name="projectcomment"></textarea>
                                </div>
                            </div>
                           
                        </div>
                        <div class="modal-footer">
                            <button type="submit"  class=" btn blue"> <i class="fa fa-plus"></i><?php _e('Edit', 'wpttar'); ?></button>
                            <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default wpttar-addlog"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
                        </div>
                    </form>
                    <!-- END FORM-->
                </div>
            </div>
        </div></div></div>

<div id="wpttar-log-request" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="alert alert-success display-hide" id="wpttarDelete_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                <button class="close" data-close="alert"></button>
            </div>
            <div class="alert alert-danger display-hide" id="wpttarDelete_error">
                <button class="close" data-close="alert"></button>
            </div>
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"><?php _e('Delete Project Log', 'wpttar'); ?></h4>
            </div>
            <div class="modal-body" id="info"><?php _e('Are you sure you went to delete log request?', 'wpttar'); ?></div>
            <div class="modal-footer">
               
                <button type="button" class="btn red wpttar-log-request"><i class="fa fa-times"></i><?php _e('Delete', 'wpttar'); ?></button>
                <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default wpttar-project-close"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
            </div>
        </div>
    </div>
</div>
<?php 

if (isset($wpttarUserRole) && $wpttarUserRole != 'administrator') { } else { ?> 
<div class="user-timer-load-in-div"></div>
<?php } ?>
