<?php
global $wpdb, $current_user;
wp_enqueue_style('wpttar-datepicker3-css');
$wpttarUserRole = $this->WPTTARGetCurrentUserCall();
$graphType = 'DayWise';
if (isset($_REQUEST['projectID']) && !empty($_REQUEST['projectID'])) :
    $projectID = $_REQUEST['projectID'];
    if (isset($_REQUEST['graphType']) && !empty($_REQUEST['graphType'])) {
        $graphType = $_REQUEST['graphType'];
    }
    $developersname = '';
    $wpttarProjectResults = $this->WPTTARGetTableDataByID($projectID, $this->WpttarProjectsTable, 'id');
    $wpttarProjectDates = $this->WPTTARGetResultsByOrderByFieldName($this->WpttarProjectsLogTable, 'projectID', $projectID, 'updateDate', 'ASC', 'getRow');
    if (!empty($wpttarProjectResults)) {
        $developersname = $this->WPTTARSetUnSerialize($wpttarProjectResults->members);
    }
    $wpttarDocuments = $this->WPTTARGetTableDataByID($projectID, $this->WpttarAttachmentsTable, 'projectID');
    if (!empty($wpttarDocuments)) {
        $attechmentArray = $this->WPTTARSetUnSerialize($wpttarDocuments->attachmentLink);
        $documentnameArray = $this->WPTTARSetUnSerialize($wpttarDocuments->documentName);
    }
    
    $wpttarProjectHours = $this->WPTTARGetResultsByID($projectID, $this->WpttarProjectsLogTable, 'projectID');
    $getTotalHour = $this->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
endif;
$wpttarGetPagePermissions = $this->WPTTARGetPagePermissions();
?> 
<input type="hidden" id="project-by-id" value="<?php
if (isset($projectID)) : echo esc_attr($projectID);
endif;
?>">
<div class="preloader">  <span class="preloader-custom-gif"></span></div>
<input type="hidden" id="current-role-member" value="<?php echo $wpttarUserRole; ?>">
<input type="hidden" id="project-wise-members-names" value="<?php echo htmlentities($projectGraphReports['member'], ENT_QUOTES, 'UTF-8'); ?>">
<input type="hidden" id="project-wise-members-hours" value="<?php echo htmlentities($projectGraphReports['hour'], ENT_QUOTES, 'UTF-8'); ?>">
<input type="hidden" id="project-wise-time-key" value="<?php echo htmlentities($projectGraphReports['graphType'], ENT_QUOTES, 'UTF-8'); ?>">
<div style="padding-left: 0px; padding-right:20px; padding-top:0px;" class="col-md-12">
    <h3 class="page-title"><?php _e('Project Details', 'wpttar'); ?></h3>
    <div class="page-bar">
        <ul class="page-breadcrumb"> <li><a href="?page=wpttar-projects"><i class="fa fa-home"></i><?php _e('Home', 'wpttar'); ?><i class="fa fa-angle-right"></i></a></li>
            <li><?php _e('Project Details', 'wpttar'); ?></li>
        </ul>   
    </div>
    <div class="row ">
        <div class="col-md-12 col-sm-12">

            <?php if (in_array('manage_options_projects', $wpttarGetPagePermissions)) { ?> 
                <a class="btn green " href="?page=wpttar-projects" ><i class="fa fa-arrow-left"></i><?php _e('Back', 'wpttar'); ?> </a>
            <?php } else { ?>
                <a class="btn green " href="?page=wpttar-developer-projects-details" ><i class="fa fa-arrow-left"></i><?php _e('Back', 'wpttar'); ?> </a>
            <?php } ?>
            <div class="portlet box blue">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-file-code-o"></i><?php _e('Summary', 'wpttar'); ?>
                    </div>

                </div>
                <div class="portlet-body">

                    <table class="table table-striped table-bordered table-hover ">
                        <thead>
                            <tr>
                                <th><?php _e('Project Title', 'wpttar'); ?></th>
                                <th><?php _e('Client Name', 'wpttar'); ?></th>
                                <th><?php _e('Server Details', 'wpttar'); ?></th>
                                <th><?php _e('Attachments', 'wpttar'); ?></th>
                                <th><?php _e('Duration', 'wpttar'); ?></th>
                                <th><?php _e('Total Time', 'wpttar'); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                            <tr id="row">
                                <td><?php
                                    if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                    endif;
                                    ?></td>
                                <td><?php
                                    if (isset($wpttarProjectResults->clientName)) : echo esc_html($wpttarProjectResults->clientName);
                                    endif;
                                    ?></td>
                                <td style="width: 40%;"><?php
                                    if (isset($wpttarProjectResults->description)) : echo stripslashes($wpttarProjectResults->description);
                                    endif;
                                    ?></td>
                                <td>
                                    <table class="leaves">
                                        <?php
                                        $i = 1;
                                        if (!empty($documentnameArray['documentlink'])) {
                                            foreach ($documentnameArray['documentlink'] as $keylink => $attechmentlink) {
                                                foreach ($documentnameArray['documentName'] as $keyname => $documentnameArrays) {
                                                    if ($keylink == $keyname) {
                                                        $feat_image = wp_get_attachment_url($attechmentlink);
                                                        ?><tr><td style="float: left;"> <a target="blank" href="<?php echo esc_attr($feat_image); ?>"><?php
                                                        if (isset($documentnameArrays)) : echo esc_html($i) . ') ' . esc_html($documentnameArrays);
                                                        endif;
                                                        ?></a></td></tr>
                                                        <?php
                                                        $i++;
                                                    }
                                                }
                                            }
                                        }
                                        ?></table></td>
                                <td><?php
                                    if (!empty($wpttarProjectDates->updateDate)) {
                                        if (isset($wpttarProjectDates->updateDate)) : echo esc_html(date('d M Y', strtotime($wpttarProjectDates->updateDate)));
                                        endif;
                                        ?>&nbsp;-<?php
                                        if (isset($wpttarProjectResults->projectStatus) && ($wpttarProjectResults->projectStatus == 'Open' || $wpttarProjectResults->projectStatus == 'Reopen' )) {
                                            _e('In Progress', 'wpttar');
                                        } else {
                                            echo ' ' . esc_html(date('d M Y', strtotime($wpttarProjectResults->lastUpdate)));
                                        }
                                    } else {
                                        
                                    }
                                    ?></td>
                                <td><?php
                                    if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour']);
                                    endif;
                                    ?>&nbsp;
                                    <?php
                                    if (isset($getTotalHour['minutes'])) : echo esc_html($getTotalHour['minutes']);
                                    endif;
                                    ?></td>
                            </tr>  

                        </tbody>
                    </table> 
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="portlet box blue">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-bar-chart"></i><?php _e('Hourly Report', 'wpttar'); ?>
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="graph" style="margin-top: 17px;"><tr><td>
                                <div class="form-group filtercontain">
                                    <select class="customwidth form-control" id="graphType">
                                        <option <?php if (isset($_REQUEST['graphType']) && $_REQUEST['graphType'] == 'DayWise') { ?> selected="selected" <?php } ?> value="DayWise"><?php _e('Day Wise', 'wpttar'); ?></option>
                                        <option <?php if (isset($_REQUEST['graphType']) && $_REQUEST['graphType'] == 'MonthWise') { ?> selected="selected" <?php } ?> value="MonthWise"><?php _e('Month Wise', 'wpttar'); ?></option>                                    
                                        <option <?php if (isset($_REQUEST['graphType']) && $_REQUEST['graphType'] == 'YearWise') { ?> selected="selected" <?php } ?> value="YearWise"><?php _e('Year Wise', 'wpttar'); ?></option>                                    
                                    </select>
                                </div></td>

                            <td><div class="form-group filtercontain">
                                    <input type="text" id="startRevenuesDate" class="form-control month-year" placeholder="<?php _e('Start Date', 'wpttar'); ?>">
                                </div> </td>
                            <td><div class="form-group filtercontain">
                                    <input type="text" id="endRevenuesDate" class="form-control month-year" placeholder="<?php _e('End Date', 'wpttar'); ?>">
                                </div></td>
                            <td><div class="form-group filtercontain">
                                    <button type="button" id="revenue-generator" class="btn btn-info btn-fill"><?php _e('Filter', 'wpttar'); ?></button>
                                </div></td>
                        </tr>
                    
                        <tr><td></td><td style="text-align: center;"><strong class="revenuemsg"></strong></td></tr>
                    </table>

                    
                    <div id="chart1" style="height:350px; width:890px; margin-left: 62px"></div>
                    <div id="chartTooltip" style="position: absolute; z-index: 99; display: none;"></div>
                </div>
            </div>
        </div></div>
    <?php if (in_array('manage_options_projects', $wpttarGetPagePermissions)) { ?> 
        <div class="row">
            <div class="col-md-12">
                <div class="portlet box blue">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-fa fa-list"></i><?php _e('Associated Team Members', 'wpttar'); ?>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                            <thead>
                                <tr>
                                    <th><?php _e('S.No', 'wpttar'); ?></th>
                                    <th class="text-center"><?php _e('Name', 'wpttar'); ?></th>
                                    <th><?php _e('Total Hours', 'wpttar'); ?></th>
                                    <th><?php _e('Comments', 'wpttar'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                if (isset($developersname) && $developersname != '') {
                                    foreach ($developersname as $developersnamesID) {
                                        $wpttarProjectHours = $this->WPTTARGetResultsByMultipleFields($this->WpttarProjectsLogTable, 'projectID', 'developerID', $projectID, $developersnamesID, 'getResults');
                                        
                                        $getTotalHour = $this->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
                                        if (in_array('manage_options_projects', $wpttarGetPagePermissions)) {
                                         $user_info = get_userdata($developersnamesID);
                                $WpttarEmployeeFirstName = $user_info->user_nicename;
                                         $WpttarEmployeeLastName = '';   
                                        }else{
                                        $WpttarEmployeeFirstName = get_user_meta($developersnamesID, 'first_name', true);
                                        $WpttarEmployeeLastName = get_user_meta($developersnamesID, 'last_name', true);
                                        }
                                        ?>
                                        <tr id="row">
                                            <td><?php echo esc_html($i); ?></td>
                                            <td class="text-center"><a href="?page=wpttar-developer-projects-details&mypage=viewpage&projectID=<?php echo esc_attr($projectID); ?>&developerID=<?php echo esc_attr($developersnamesID); ?>"><?php
                                                    if (isset($WpttarEmployeeFirstName)): echo esc_html($WpttarEmployeeFirstName . ' ');
                                                    endif;
                                                    ?><?php
                                                    if (isset($WpttarEmployeeLastName)): echo esc_html($WpttarEmployeeLastName);
                                                    endif;
                                                    ?></a></td>
                                            <td><?php
                                                if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour']);
                                                endif;
                                                ?>&nbsp;
                                                <?php
                                                if (isset($getTotalHour['minutes'])) : echo esc_html($getTotalHour['minutes']);
                                                endif;
                                                ?></td>
                                            <td>
                                             <?php if(!empty($wpttarProjectHours)) { ?>
                                           <a href="?page=wpttar-developer-projects-comments&developerID=<?php echo esc_attr($developersnamesID); ?>&projectID=<?php echo esc_attr($projectID); ?>&action='Userpage'" class="blue color"><i class="fa fa-eye"></i></a>
                                            <?php }else{ ?>
                                           <a style="color: silver;" title="<?php _e('No comments available!', 'wpttar'); ?>" class="blue color"><i class="fa fa-eye"></i></a>     
                                           <?php } ?>
                                            
                                               </td>
                                        </tr>  
                                        <?php
                                        $i++;
                                    }
                                }
                                ?>
                            </tbody>
                        </table>  
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
</div>

<div class="user-timer-load-in-div"></div>

<!-- END PAGE CONTENT-->

<script>
//** Start Load Jquery Plote Graph **//
    jQuery(document).ready(function () {
       
        
        jQuery(".month-year").datepicker({
            format: "M-yyyy",
            viewMode: "months",
            minViewMode: "months",
            autoclose: true
        });
        var productID = jQuery("#project-by-id").val();
        var graphType = jQuery("#graphType").val();
        wpttarGetTimeDisplay(productID, graphType, '', '');
    });

    jQuery("#revenue-generator").click(function () {
        var productid = jQuery("#project-by-id").val();
        var graphType = jQuery("#graphType").val();
        var startRevenuesDate = jQuery("#startRevenuesDate").val();
        var endRevenuesDate = jQuery("#endRevenuesDate").val();
        wpttarGetTimeDisplay(productid, graphType, startRevenuesDate, endRevenuesDate);
    })

    function wpttarGetTimeDisplay(productID, graphType, startDate, endDate) {
        jQuery('#chart1').empty();
        jQuery('.revenuemsg').empty();
        jQuery(".preloader-custom-gif").show();
        jQuery(".preloader").show();
        wpttar_data = {
            action: 'WPTTARProjectGraphReports',
            productID: productID,
            startDate: startDate,
            endDate: endDate,
            graphType: graphType
        }, jQuery.post(ajaxurl, wpttar_data, function (b) {
            var data = JSON.parse(b);
            if (data.error) {
                jQuery(".preloader-custom-gif").hide();
                jQuery(".preloader").hide();
                jQuery(".revenuemsg").html(data.error);
            } else {
                jQuery(".preloader-custom-gif").hide();
                jQuery(".preloader").hide();
                var projectWiseMemberHours = data.hour;
                var projectWiseMemberkeys = data.graphType;
                var projectWiseMembers = data.member;
                var ticks = projectWiseMemberkeys;
                var plot1 = jQuery.jqplot('chart1', projectWiseMemberHours, {
                    title: '',
                    seriesDefaults: {
                        renderer: jQuery.jqplot.BarRenderer,
                        rendererOptions: {fillToZero: true,
                            barWidth: 20,
                            shadow: false,
                        }

                    },
                    series: projectWiseMembers,
                    highlighter: {
                        showLabel: false,
                        show: true,
                        tooltipLocation: 'n',
                        tooltipAxes: 'y',
                        sizeAdjust: -8,
                        tooltipFormatString: '<table class="jqplot-highlighter"><tr><td>Time : %#.2f hr</td></tr></table>',
                        useAxesFormatters: false
                    },
                    cursor: {
                        zoom: true,
                        tooltipOffset: 10,
                        tooltipLocation: 'nw'
                    },
                    legend: {
                        show: true,
                        placement: 'outsideGrid'
                    },
                    axes: {
                        xaxis: {
                            renderer: jQuery.jqplot.CategoryAxisRenderer,
                            ticks: ticks,
                        },
                        yaxis: {
                            pad: 1.05,
                            tickOptions: {formatString: '%d hr'},
                            min: 0

                        },
                    }
                });

            }
        })

    }


</script>