<?php
global $current_user, $wpdb;
$wpttarUserRole = $this->WPTTARGetCurrentUserCall();
$timezoneIdentifiers = DateTimeZone::listIdentifiers();
$wpttarTimeZoneSettings = $this->WPTTARGetSettings('wpttarTimeZoneSettingsInfo');
$wpttarTeamMemberInfo = $this->WPTTARGetSettings('wpttarTeamMemberInfo');
if (isset($wpttarTimeZoneSettings['wpttar-time-zone']) && $wpttarTimeZoneSettings['wpttar-time-zone'] != '') {
    $wpttarMessagesTimeZoneSettings = $this->WPTTARGetMessage(2);
    }else{
     $wpttarMessagesTimeZoneSettings = $this->WPTTARGetMessage(1);   
    }
     $wpttarUpdateMessageSettings = $this->WPTTARGetMessage(5); 
?>
<div class="preloader">  <span class="preloader-custom-gif"></span></div>
<div id="wpttar-edit-message" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-close"></i></button>
                <h4 class="modal-title"><strong><i class="fa fa-edit"></i> &nbsp;<?php _e('Edit Message', 'wpttar'); ?></strong></h4>
            </div>
            <div class="modal-body">
                <div class="portlet-body form">
                    <div class="alert alert-success display-hide" id="wpttar-messages-success"><i class='fa fa-check-square' aria-hidden='true'></i> <?php echo esc_html($wpttarUpdateMessageSettings); ?>
                        <button class="close" data-close="alert"></button>
                    </div>
                    <div class="alert alert-danger display-hide" id="wpttar-messages-error">
                        <button class="close" data-close="alert"></button>
                    </div>
                    <!-- BEGIN FORM-->
                    <form method="POST"  accept-charset="UTF-8" class="form-horizontal" id="wpttar-messages-form">
                        <div class="form-body">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <input name="wpttar-messages-id" id="wpttar-messages-id" type="hidden" />
                                    <input class="form-control form-control-inline " name="wpttar-messages-title" id="wpttar-messages-title" type="text" value="" placeholder="<?php _e('Messages title', 'wpttar'); ?>" />
                                </div>
                            </div>
                        </div>
                        <div class="form-body">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <input class="form-control form-control-inline " name="wpttar-messages-desc" id="wpttar-messages-desc" type="text" value="" placeholder="<?php _e('Messages Description', 'wpttar'); ?>" />
                                </div> 
                            </div>
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="submit"  class="btn blue"><i class="fa fa-edit"></i><?php _e('Edit Message', 'wpttar'); ?></button>
                                    <button type="button" data-dismiss="modal" class="btn red"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                    <!-- END FORM-->
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
</div>
<!-- BEGIN PAGE HEADER-->
<div class="col-md-12">
    <h3 class="page-title"><?php _e('Settings', 'wpttar'); ?></h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li><i class="fa fa-home"></i><?php _e('Home', 'wpttar'); ?><i class="fa fa-angle-right"></i></li>
            <li><?php _e('Settings', 'wpttar'); ?></li>
        </ul>
    </div>
    <div class="row ">
        <div class="col-md-6 col-sm-6">
            <div class="portlet box blue">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="fa fa-clock-o"></i><?php _e('Date and Time Settings', 'wpttar'); ?>
                    </div>
                    <div class="actions">
                        <a href="javascript:;" onclick="jQuery('#wpttat-time-zone-form').submit();"  class="demo-loading-btn btn btn-sm btn-default ">
                            <i class="fa fa-save" ></i> <?php _e('Save', 'wpttar'); ?>
                        </a>
                    </div>
                </div>
                <div class="portlet-body" style="height: 233px;">
                    <div class="alert alert-success display-hide" id="wpttar-time-zone-success"><i class='fa fa-check-square' aria-hidden='true'></i> <?php echo esc_html($wpttarMessagesTimeZoneSettings); ?>
                        <button class="close" data-close="alert"></button>
                    </div>
                    <div class="alert alert-danger display-hide" id="wpttar-time-zone-error">
                        <button class="close" data-close="alert"></button>
                    </div>
                    <form style="margin-top: 15px;" method="POST"  accept-charset="UTF-8" class="form-horizontal" id="wpttat-time-zone-form">   
                        <div id="alert_bank"></div>
                        <div class="form-body">
                            
                                 <div class="form-group">
                                <label class="col-md-4 control-label"><?php _e('Select Time Zone', 'wpttar'); ?></label>
                                <div class="col-md-8">
                                    <p><select id="my-select" name="wpttar-time-zone" id="wpttar-time-zone">
                                            <?php
                                            if (!empty($timezoneIdentifiers)) {
                                                foreach ($timezoneIdentifiers as $key => $timezoneIdentifier) {
                                                    ?> <option value="<?php
                                                    if (isset($timezoneIdentifier)): echo esc_attr($timezoneIdentifier);
                                                    endif;
                                                    ?>" <?php if (isset($timezoneIdentifier) && isset($wpttarTimeZoneSettings['wpttar-time-zone']) && $timezoneIdentifier == $wpttarTimeZoneSettings['wpttar-time-zone']) { ?> selected="selected" <?php } ?> ><?php
                                                                if (isset($timezoneIdentifier)): echo esc_html($timezoneIdentifier);
                                                                endif;
                                                                ?></option>
                                                <?php
                                                }
                                            }
                                            ?>  
                                        </select></p>
                                        
                                </div>
                                <label class="col-md-4 control-label"><span class="label label-danger span-padding"><?php _e('NOTE', 'wpttar'); ?> !</span></label>
                                <div class="col-md-8">
                                 <?php _e("Please set the time zone only when there is no open project.", 'wpttar'); ?>  
                                </div>
                                 </div>
                            <div class="form-group">
                                <label class="control-label col-md-4"><?php _e('Time Format', 'wpttar'); ?></label>
                                <div class="col-md-8">
                                    <input style="margin: 8px 1px;" name="wpttar-time-format" type="radio" <?php
                                                    if (isset($wpttarTimeZoneSettings['wpttar-time-format']) && $wpttarTimeZoneSettings['wpttar-time-format'] == '24 Hour') { ?> checked="checked" <?php } ?>
                                                     id="wpttar-time-format" value="24 Hour">&nbsp;<?php _e('24 Hour', 'wpttar'); ?> &nbsp;&nbsp;&nbsp;&nbsp;
                                                    <input  name="wpttar-time-format" type="radio" id="wpttar-time-format" <?php
                                                    if (isset($wpttarTimeZoneSettings['wpttar-time-format']) && $wpttarTimeZoneSettings['wpttar-time-format'] == '12 Hour') { ?> checked="checked" <?php } ?>
                                                    value="12 Hour" >&nbsp;<?php _e('12 Hour', 'wpttar'); ?>
                                </div>
                            </div> 
                        
                        </div>
                    </form>
                </div>
            </div>
              
            
          <?php if (isset($current_user->roles) &&  in_array('administrator', $current_user->roles)) { ?>
                    <div class="portlet box  blue">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-user"></i><?php _e('View Users', 'wpttar'); ?>
                </div>
                <div class="actions">
                    <a href="javascript:;"  onclick="jQuery('#wpttarTeamMemberRoleAssignForm').submit();"  class="demo-loading-btn btn btn-sm btn-default ">
                        <i class="fa fa-save" ></i><?php _e('Save', 'wpttar'); ?> </a>
                </div>
            </div>
            <div class="portlet-body">
                 <div class="alert alert-success display-hide" id="TeamMemberRoleAssign_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="alert alert-danger display-hide" id="TeamMemberRoleAssign_error">
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="form-body">
                    
                    <form method="POST"  accept-charset="UTF-8" class="form-horizontal" id="wpttarTeamMemberRoleAssignForm"> 
                         <div class="form-group" >
                             <label class="col-md-4 control-label"><span class="label label-danger span-padding"><?php _e('NOTE', 'wpttar'); ?> !</span></label>
                        <div class="col-md-8">
                                 <?php _e("You must add the new Role that you have created in View Users section.", 'wpttar'); ?>  
                        </div></div>
                        <div class="form-group" >
                            <label class="col-md-4 control-label"><?php _e('Roles', 'wpttar'); ?></label>
                            <div class="col-md-8">
                                 <p><select id="my-team-members" name="wpttar-team-member-name[]" id="wpttar-team-member-name" multiple="multiple" required="required">
                                        <?php
                                            $wpttarGetUser = $this->WPTTARGetUserRoles();
                                                if (!empty($wpttarGetUser)) {
                                                    foreach ($wpttarGetUser as $key => $userdata) {
                                                        if(in_array($key, $wpttarTeamMemberInfo)){
                                                            ?> <option value="<?php
                                                            if (isset($key)): echo esc_attr($key);
                                                            endif;
                                                            ?>" selected="selected"><?php
                                                                        if (isset($userdata)): echo esc_html($userdata);
                                                                        endif;
                                                                        ?></option>    

                                                <?php }else{ ?>
                                               <option value="<?php
                                                            if (isset($key)): echo esc_attr($key);
                                                            endif;
                                                            ?>"><?php
                                                                        if (isset($userdata)): echo esc_html($userdata);
                                                                        endif;
                                                                        ?></option>       
                                               <?php } }
                                                }
                                            
                                            ?>  
                                        </select></p>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
            
            <div class="portlet box  blue">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-user"></i><?php _e('Role Permissions', 'wpttar'); ?>
                </div>
                <div class="actions">
                    <a href="javascript:;"  onclick="jQuery('#wpttarRolePermissionForm').submit();"  class="demo-loading-btn btn btn-sm btn-default ">
                        <i class="fa fa-save" ></i><?php _e('Save', 'wpttar'); ?> </a>
                </div>
            </div>
            <div class="portlet-body">
                 <div class="alert alert-success display-hide" id="addroles_settings_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="alert alert-danger display-hide" id="addroles_settings_error">
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="form-body">
                    
                    <form method="POST"  accept-charset="UTF-8" class="form-horizontal" id="wpttarRolePermissionForm">    
                         <div class="form-group">
                            <label class="col-md-4 control-label"><?php _e('Role Action', 'wpttar'); ?></label>
                            <div class="col-md-8">
                              <a class="btn yellow" onclick="wpttarRoleAction('add')"><i class="fa fa-plus"></i><?php _e('Add', 'wpttar'); ?> </a>
                              <a class="btn blue"  onclick="wpttarRoleAction('edit')"><i class="fa fa-edit"></i><?php _e('Edit', 'wpttar'); ?> </a>
                            </div>
                        </div>
                        <div class="edit-role">
                        <div class="form-group" >
                            <label class="col-md-4 control-label"><?php _e('Roles', 'wpttar'); ?></label>
                            <div class="col-md-8">
                                <select class="bs-select form-control wpttar_user_permission" data-show-subtext="true" name="wpttar_user_permission" id="rolenameget">
                                    
                                </select>
                            </div>
                        </div>
                        </div>
                        
                      <div class="add-role">
                        <div class="form-group">
                            <label class="col-md-4 control-label"><?php _e('Role Name', 'wpttar'); ?></label>
                            <div class="col-md-8">
                                <input class="form-control"  name="wpttar_rolename" type="text" id="wpttar_rolename">
                            </div>
                        </div>
                          </div>
                        <table class="table table-striped table-bordered table-hover role-permission-show" id="role-permission-show">
                        </table>
                    </form>
                </div>
            </div>
        </div>
        <?php } ?>
        </div>
          <div class="col-md-6 col-sm-6">
          <div class="portlet box red">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-envelope"></i><?php _e('Messages Settings', 'wpttar'); ?>
                </div>
            </div>
            <div class="portlet-body">
                <div class="form-body">
                    <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                        <thead>
                            <tr> <th><?php _e('S.No', 'wpttar'); ?></th>
                                <th><?php _e('Message titles', 'wpttar'); ?></th>
                                <th><?php _e('Message Descriptions', 'wpttar'); ?></th>
                                <th><?php _e('Action', 'wpttar'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $i = 1;
                            $wpttarMessages = $wpdb->get_results("SELECT * FROM $this->WpttarMessagesTable ORDER BY id ASC");
                            foreach ($wpttarMessages as $key => $wpttarMessage) {
                                ?>
                                <tr>
                                    <td><?php echo esc_html($i); ?></td>
                                    <td> <?php
                                        if (isset($wpttarMessage->messagesTitle)) : echo esc_html($wpttarMessage->messagesTitle);
                                        endif;
                                        ?> </td>
                                    <td> <?php
                                        if (isset($wpttarMessage->messagesDesc)) : echo esc_html($wpttarMessage->messagesDesc);
                                        endif;
                                        ?> </td>
                                    <td>
                                        <a class="blue color" data-toggle="modal" href="#wpttar-edit-message" onclick="WPTTAREditMessages(<?php
                                        if (isset($wpttarMessage->id)) : echo esc_js($wpttarMessage->id);
                                        endif;
                                        ?>, '<?php
                                        if (isset($wpttarMessage->messagesTitle)) : echo trim(esc_js($wpttarMessage->messagesTitle));
                                        endif;
                                        ?>', '<?php
                                        if (isset($wpttarMessage->messagesDesc)) : echo trim(esc_js($wpttarMessage->messagesDesc));
                                        endif;
                                        ?>')"> <i class="fa fa-edit"></i></a>
                                    </td>
                                </tr>
                                <?php
                                $i++;
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        </div>
    </div>

</div>
<script> jQuery(function () {
    jQuery('.my-date-formate').searchableOptionList({});
})</script>