<?php
/**
 * CTP entry content
 *
 * @package Total WordPress theme
 * @subpackage Partials
 * @version 5.0
 */

defined( 'ABSPATH' ) || exit;

?>

<div <?php wpex_cpt_entry_excerpt_class(); ?>>
	<?php
	// Check if post has a "more" tag
	if ( true === apply_filters( 'wpex_check_more_tag', true ) && strpos( get_the_content(), 'more-link' ) ) :

		// Display entry content up to the more tag
		the_content( '', '&hellip;' );

	// Generate custom excerpt
	else :

		// Get excerpt length
		$excerpt_length = apply_filters( 'wpex_' . get_post_type() . '_entry_excerpt_length', '40' );

		// Output excerpt
		wpex_excerpt( array(
			'length' => $excerpt_length,
		) );

	endif; ?>
</div>